<?php
ini_set('display_errors', 0);
error_reporting(E_ALL);

require_once "openai-config/config.php";
require_once "connect.php";

header("Access-Control-Allow-Origin: https://haihoanpetcare.online");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Content-Type: application/json; charset=utf-8");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

// =========================
// NHẬN INPUT
// =========================
$input = json_decode(file_get_contents('php://input'), true);
if (!$input || !isset($input['message'])) {
    echo json_encode(["reply" => "Không nhận được nội dung!"], JSON_UNESCAPED_UNICODE);
    exit;
}

$userMessage = trim($input['message']);
$clean = mb_strtolower($userMessage, "UTF-8");


// =========================
// 0 — THÔNG TIN LIÊN LẠC
// =========================
$contact_keywords = [
    "liên lạc", "hotline", "sđt", "sdt", "địa chỉ", "email", 
    "liên hệ", "contact", "support"
];

foreach ($contact_keywords as $c) {
    if (mb_stripos($clean, $c) !== false) {

        echo json_encode([
            "reply" => "Đây là các địa chỉ liên hệ của chúng tôi:
📧 Email: haihoanpetcare@gmail.com
📞 Hotline: 6969-696-###
📍 TP.HCM, Việt Nam
"
        ], JSON_UNESCAPED_UNICODE);

        exit;
    }
}


// =========================
// 1 — SMALL TALK CHUẨN
// =========================
$smallTalkPatterns = [
    "xin chào", "chào bạn", "chào ad", "chào ai", "hello", "hi", "hê lô", "alo"
];

$medicalKeywords = [
    "bị", "ngứa", "đau", "ghẻ", "mẩn đỏ", "sưng", "ói", "nôn", "ỉa", 
    "tiêu chảy", "ho", "khò khè", "sốt", "mụn", "lở", "triệu chứng"
];

foreach ($medicalKeywords as $m) {
    if (mb_stripos($clean, $m) !== false) {
        goto SKIP_SMALL_TALK;
    }
}

if (strlen($clean) > 15 && strpos($clean, '?') !== false) {
    goto SKIP_SMALL_TALK;
}

foreach ($smallTalkPatterns as $s) {
    if ($clean === $s || strpos($clean, $s) === 0) {
        echo json_encode([
            "reply" => "Chào bạn! Mình là trợ lý AI thú cưng của HaiHoanPetCare. Bạn cần hỗ trợ điều gì nè?"
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }
}

SKIP_SMALL_TALK:


// =========================
// 2 — SQL (match triệu chứng)
// =========================
$q = $conn->query("SELECT * FROM ai_knowledge");
$foundSQL = false;
$sqlReply = "";

while ($row = $q->fetch_assoc()) {

    $symptom = mb_strtolower(trim($row['symptoms']), "UTF-8");

    if ($symptom !== "" && mb_stripos($clean, $symptom) !== false) {
        $foundSQL = true;

        // TRẢ LỜI NGẮN GỌN
        $sqlReply = "Theo dữ liệu ghi nhận từ HaiHoanPetCare, thú cưng của bạn thuộc loài {$row['species']} và giống {$row['breed']}.
Triệu chứng được tìm thấy trùng khớp: {$row['symptoms']}.
Chẩn đoán gợi ý bên chúng tôi: {$row['diagnosis']}.
Cách điều trị phù hợp bên chúng tôi: {$row['treatment']}.
Nếu như tình trạng kéo dài hoặc trở nên nghiêm trọng hơn, bạn nên đưa thú cưng đến bác sĩ thú y để được thăm khám và chăm sóc kịp thời.";

        break;
    }
}


// =========================
// 3 — KẾT QUẢ
// =========================

// Nếu tìm thấy SQL → chỉ trả về SQL (không GPT fallback)
if ($foundSQL) {
    echo json_encode([
        "reply" => $sqlReply
    ], JSON_UNESCAPED_UNICODE);
    exit;
}


// =========================
// 4 — GPT FALLBACK (khi không có SQL)
// =========================
function callGPT($text)
{
    $payload = [
        "model" => "gpt-4o-mini",
        "temperature" => 0.6,
        "messages" => [
            [
                "role" => "system",
                "content" =>
"Bạn là bác sĩ thú y ảo của HaiHoanPetCare.
Luôn trả lời tiếng Việt, ngắn gọn, thân thiện, dễ hiểu."
            ],
            [
                "role" => "user",
                "content" => $text
            ]
        ]
    ];

    $ch = curl_init("https://api.openai.com/v1/chat/completions");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_TIMEOUT => 12,
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "Authorization: Bearer " . OPENAI_API_KEY
        ],
        CURLOPT_POSTFIELDS => json_encode($payload)
    ]);

    $resp = curl_exec($ch);

    if ($resp === false) {
        return "Máy chủ đang bận, bạn thử lại sau nhé!";
    }

    $data = json_decode($resp, true);

    return $data["choices"][0]["message"]["content"] ?? "Không thể xử lý yêu cầu.";
}


echo json_encode([
    "reply" => callGPT($userMessage)
], JSON_UNESCAPED_UNICODE);

exit;
?>
